#!/bin/bash
#
# update python-logfmter src
#
# SPDX-FileCopyrightText: 2001-2025 Univention GmbH
# SPDX-License-Identifier: AGPL-3.0-only

set -e

VERSION=0.0.10
TAR_DIR=python-logfmter-$VERSION
TAR_FILE=python-logfmter-v$VERSION.tar.gz
TAR_URL=https://github.com/jteppinette/python-logfmter/archive/refs/tags/v$VERSION.tar.gz

wget -O $TAR_FILE $TAR_URL
sha256sum -c $TAR_FILE.sha256
rm -rf ./src ./tests
tar xvzf $TAR_FILE $TAR_DIR/src $TAR_DIR/tests $TAR_DIR/setup.cfg $TAR_DIR/setup.py $TAR_DIR/LICENSE.txt
mv $TAR_DIR/* .
